-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p0 = Citadels.GetPlayer(0)
    self.ironMine:LinkToTarget("ironQuest")
    self.msgIron:LinkToTarget("ironQuestMsg")
    
    if not self.loaded then
      self.completed = 0
      self.timer = 4
      self.active = true    
      self.msgAdded = false
      self.msgDeact = false
    end
  end
    
  if self.active then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      CheckForPlayer(self)
    end
  end 
end

function CheckForPlayer(self)
  p0units = self.p0:UnitsInRadiusNumber(self:GetPosition(), 2000, '*')
  
  if p0units > 1 then
    self.msgIron:TriggerAllTargets()
    self.active = false
  end
end

function OnBeforeDeath(self)
  self.ironMine:TriggerAllTargets()
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.completed = ar:Read()
    self.timer = ar:Read()
    self.active = ar:Read()
    self.msgAdded = ar:Read()
    self.msgDeact = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.completed)
    ar:Write(self.timer)
    ar:Write(self.active)
    ar:Write(self.msgAdded)
    ar:Write(self.msgDeact)
  end
end

function CreateTriggerSources(self)
  self:AddTriggerSource("ironMine")
  self:AddTriggerSource("msgIron")
end
